<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\ContributionZUS;

/**
 * ContributionZUSRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ContributionZUSRepository extends EntityRepository
{
    /**
     * add new ContributionZUS
     *
     * @param $data
     * @param bool $flush
     * @return ContributionZUS
     */
    public function add($data, $flush = false)
    {
        $ContributionZUS = new ContributionZUS();

        $ContributionZUS->setMonthFrom($data['month']);
        $ContributionZUS->setYearFrom($data['year']);
        $ContributionZUS->setMonthTo($data['monthTo']);
        $ContributionZUS->setYearTo($data['yearTo']);
        $ContributionZUS->setDescription(ucfirst($data['description']));

        $ContributionZUS->setEmployeeE($data['value']['employee']['emerytalne']);
        $ContributionZUS->setEmployeeR($data['value']['employee']['rentowe']);
        $ContributionZUS->setEmployeeCh($data['value']['employee']['chorobowe']);
        $ContributionZUS->setEmployeeW($data['value']['employee']['wypadkowe']);
        $ContributionZUS->setEmployeeZ($data['value']['employee']['zdrowotne']);
        $ContributionZUS->setEmployerE($data['value']['employer']['emerytalne']);
        $ContributionZUS->setEmployerR($data['value']['employer']['rentowe']);

        $this->getEntityManager()->persist($ContributionZUS);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $ContributionZUS;
    }

    /**
     * @param $monthFrom
     * @param $yearFrom
     * @param $monthTo
     * @param $yearTo
     * @return null|ContributionZUS
     */
    public function getContributionZUSForMonthAndYear($monthFrom,$yearFrom,$monthTo,$yearTo)
    {
        $QueryBuilder = $this->createQueryBuilder('p');
        $QueryBuilder
            ->select('p')
            ->where($QueryBuilder->expr()->eq('p.yearFrom',$yearFrom))
            ->andWhere($QueryBuilder->expr()->eq('p.monthFrom',$monthFrom))
            ->andWhere($QueryBuilder->expr()->eq('p.yearTo',$yearTo))
            ->andWhere($QueryBuilder->expr()->eq('p.monthTo',$monthTo))
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }
}
